//=============================================================================
// MoneyObtainTrigger.
//=============================================================================
class MoneyObtainTrigger expands Trigger;

// Gives the player some money when touched or triggered
// Set bCollideActors to False to make it triggered

var() int CashAmount;
var() localized String awardMessage;

function Trigger(Actor Other, Pawn Instigator)
{
	local DeusExPlayer player;

	Super.Trigger(Other, Instigator);

	player = DeusExPlayer(Instigator);

	if (player != None)
	{
		  player.Credits += CashAmount;
		  player.ClientMessage(Sprintf(awardMessage, CashAmount));
	}
}

function Touch(Actor Other)
{
	local DeusExPlayer player;

	Super.Touch(Other);

	if (IsRelevant(Other))
	{
		player = DeusExPlayer(Other);

		if (player != None)
		{
		  player.Credits += CashAmount;
		  player.ClientMessage(Sprintf(awardMessage, CashAmount));
		}
	}
}

defaultproperties
{
     CashAmount=10
     awardMessage="%d dollars awarded"
     bTriggerOnceOnly=True
}
